import 'package:cached_network_image/cached_network_image.dart';
import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/material.dart';
import 'package:feather_icons/feather_icons.dart';
import 'package:hive/hive.dart';
import 'package:share_plus/share_plus.dart';
import 'package:wordpress_app/blocs/ads_bloc.dart';
import 'package:wordpress_app/models/app_config_model.dart';
import 'package:wordpress_app/models/article.dart';
import 'package:wordpress_app/pages/article_details/post_date.dart';
import 'package:wordpress_app/pages/article_details/post_views.dart';
import 'package:wordpress_app/services/app_service.dart';
import 'package:wordpress_app/utils/next_screen.dart';
import 'package:wordpress_app/widgets/banner_ad.dart';
import 'package:wordpress_app/widgets/bookmark_icon.dart';
import 'package:wordpress_app/widgets/category_chip.dart';
import 'package:wordpress_app/widgets/html_body/html_body.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/widgets/related_articles.dart';
import 'package:wordpress_app/widgets/tags.dart';
import 'package:wordpress_app/widgets/video_player_widget.dart';
import 'package:youtube_player_flutter/youtube_player_flutter.dart';
import '../../blocs/config_bloc.dart';
import '../../blocs/theme_bloc.dart';
import '../../config/custom_ad_config.dart';
import '../../constants/constant.dart';
import '../../services/wordpress_service.dart';
import '../../widgets/custom_ad.dart';
import '../../widgets/native_ad_widget.dart';
import '../author_artcles.dart';
import '../comments_page.dart';

class VideoArticleDeatils extends ConsumerStatefulWidget {
  const VideoArticleDeatils({super.key, required this.article});

  final Article article;

  @override
  ConsumerState<VideoArticleDeatils> createState() =>
      _VideoArticleDeatilsState();
}

class _VideoArticleDeatilsState extends ConsumerState<VideoArticleDeatils> {
  double _fontSize = 17.0;
  static const double _minFontSize = 12.0;
  static const double _maxFontSize = 24.0;
  static const double _fontSizeStep = 2.0;

  Future _handleShare() async {
    SharePlus.instance.share(ShareParams(text: widget.article.link.toString()));
  }

  void _increaseFontSize() {
    setState(() {
      if (_fontSize < _maxFontSize) {
        _fontSize =
            (_fontSize + _fontSizeStep).clamp(_minFontSize, _maxFontSize);
      }
    });
  }

  void _decreaseFontSize() {
    setState(() {
      if (_fontSize > _minFontSize) {
        _fontSize =
            (_fontSize - _fontSizeStep).clamp(_minFontSize, _maxFontSize);
      }
    });
  }

  void _updatePostViews() {
    Future.delayed(const Duration(seconds: 2))
        .then((value) => WordPressService.addViewsToPost(widget.article.id!));
  }

  late String videoId;
  late YoutubePlayerController controller;

  void _intitYoutube() {
    if (widget.article.videoPost == true || widget.article.youtubeUrl != '') {
      final videoId =
          YoutubePlayer.convertUrlToId(widget.article.youtubeUrl.toString()) ??
              '';
      controller = YoutubePlayerController(initialVideoId: videoId);
    } else {
      controller = YoutubePlayerController(initialVideoId: '');
    }
  }

  @override
  void initState() {
    super.initState();
    _intitYoutube();

    Future.microtask(() {
      if (!mounted) return;

      final configs = ref.read(configBlocProvider).configs!;
      final adb = ref.read(adsBlocProvider);
      adb.increaseClickCounter();
      if (configs.admobEnabled && configs.interstitialAdsEnabled) {
        adb.showLoadedAd(configs.clickAmount);
      }
    });

    _updatePostViews();
  }

  @override
  Widget build(BuildContext context) {
    final Article article = widget.article;
    final bookmarkedList = Hive.box(Constants.bookmarkTag);
    final configs = ref.read(configBlocProvider).configs!;
    if (article.videoPost == true &&
        article.youtubeUrl != '' &&
        article.youtubeUrl != null) {
      return YoutubePlayerBuilder(
        player: YoutubePlayer(controller: controller),
        builder: (context, player) {
          return Scaffold(
              body: SafeArea(
            child: Column(
              children: [
                Stack(
                  children: [
                    player,
                    Positioned(
                      top: 0,
                      child: IconButton(
                        icon: const Icon(Icons.keyboard_arrow_left,
                            color: Colors.white),
                        onPressed: () => Navigator.pop(context),
                      ),
                    ),
                  ],
                ),
                _body(context, article, bookmarkedList, configs)
              ],
            ),
          ));
        },
      );
    }

    return Scaffold(
      body: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          _VideoWidget(article: article),
          _body(context, article, bookmarkedList, configs),
        ],
      ),

      // Banner Ads Admob
      bottomNavigationBar: Visibility(
        visible: configs.admobEnabled && configs.bannerAdsEnabled,
        child: const BannerAdWidget(),
      ),
    );
  }

  Expanded _body(BuildContext context, Article article,
      Box<dynamic> bookmarkedList, ConfigModel configs) {
    return Expanded(
      child: SingleChildScrollView(
        child: Column(
          children: [
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Padding(
                  padding: const EdgeInsets.fromLTRB(20, 15, 10, 0),
                  child: Column(
                    children: [
                      Row(
                        children: <Widget>[
                          CategoryChip(article: article),
                          const Spacer(),
                          BookmarkIcon(
                            bookmarkedList: bookmarkedList,
                            article: article,
                            iconSize: 22,
                            iconColor:
                                Theme.of(context).colorScheme.onSurfaceVariant,
                            normalIconColor:
                                Theme.of(context).colorScheme.onSurfaceVariant,
                          ),
                          _menuButton(context, article),
                        ],
                      ),
                      Row(
                        children: <Widget>[
                          Row(
                            children: [
                              PostDate(article: article),
                              PostViews(article: article),
                            ],
                          ),
                        ],
                      ),
                      const SizedBox(height: 10),
                      Text(
                        AppService.getNormalText(article.title!),
                        style: Theme.of(context).textTheme.titleLarge?.copyWith(
                              fontWeight: FontWeight.bold,
                              wordSpacing: 1.8,
                            ),
                      ),
                      Divider(
                        color: Theme.of(context).primaryColor,
                        endIndent: 280,
                        thickness: 2,
                      ),
                      const SizedBox(
                        height: 15,
                      ),
                      Row(
                        children: [
                          InkWell(
                            onTap: () => nextScreenPopupiOS(
                                context, AuthorArticles(article: article)),
                            child: Row(
                              children: [
                                ClipOval(
                                  child: SizedBox(
                                    height: 40,
                                    child: CachedNetworkImage(
                                        imageUrl: article.avatar.toString()),
                                  ),
                                ),
                                const SizedBox(
                                  width: 10,
                                ),
                                Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Text(
                                      article.author.toString(),
                                      maxLines: 1,
                                      overflow: TextOverflow.ellipsis,
                                      style: Theme.of(context)
                                          .textTheme
                                          .titleMedium
                                          ?.copyWith(
                                              fontSize: 15,
                                              fontWeight: FontWeight.w600),
                                    ),
                                    Row(
                                      children: [
                                        Text(
                                          AppService.getReadingTime(
                                              article.content.toString()),
                                          maxLines: 1,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                              fontSize: 14,
                                              color: Theme.of(context)
                                                  .colorScheme
                                                  .secondary),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                              ],
                            ),
                          ),
                          const Spacer(),
                          Visibility(
                            visible:
                                configs.commentsEnabled && configs.loginEnabled,
                            child: Padding(
                              padding: const EdgeInsets.only(right: 10),
                              child: Row(
                                children: <Widget>[
                                  TextButton.icon(
                                    style: TextButton.styleFrom(
                                      backgroundColor:
                                          Theme.of(context).primaryColor,
                                      shape: RoundedRectangleBorder(
                                          borderRadius: BorderRadius.circular(3)),
                                    ),
                                    icon: const Icon(FeatherIcons.messageCircle,
                                        color: Colors.white, size: 20),
                                    label: Text(
                                      'comments',
                                      style: Theme.of(context)
                                          .textTheme
                                          .titleMedium
                                          ?.copyWith(
                                              fontWeight: FontWeight.w500,
                                              color: Colors.white,
                                              fontSize: 15),
                                    ).tr(),
                                    onPressed: () => nextScreenPopupiOS(
                                        context, CommentsPage(article: article)),
                                  )
                                ],
                              ),
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
                //native ads
                Visibility(
                  visible: AppService.nativeAdVisible(
                      Constants.adPlacements[2], configs),
                  child: Padding(
                    padding: const EdgeInsets.only(top: 30),
                    child: NativeAdWidget(
                        isDarkMode:
                            ref.read(themeBlocProvider).darkTheme ?? false,
                        isSmallSize: true),
                  ),
                ),

                //custom ads
                Visibility(
                  visible: AppService.customAdVisible(
                      Constants.adPlacements[2], configs),
                  child: Container(
                    height: CustomAdConfig.defaultBannerHeight,
                    padding: const EdgeInsets.only(top: 30),
                    child: CustomAdWidget(
                      assetUrl: configs.customAdAssetUrl,
                      targetUrl: configs.customAdDestinationUrl,
                    ),
                  ),
                ),
                HtmlBody(
                  content: article.content!,
                  isVideoEnabled: false,
                  isimageEnabled: true,
                  isIframeVideoEnabled: false,
                  fontSize: _fontSize,
                ),
                const SizedBox(height: 20),
                Tags(tagIds: article.tags!)
              ],
            ),
            //native ads
            Visibility(
              visible: AppService.nativeAdVisible(
                  Constants.adPlacements[3], configs),
              child: Padding(
                padding: const EdgeInsets.only(bottom: 30),
                child: NativeAdWidget(
                    isDarkMode: ref.read(themeBlocProvider).darkTheme ?? false,
                    isSmallSize: true),
              ),
            ),

            //custom ads
            Visibility(
              visible: AppService.customAdVisible(
                  Constants.adPlacements[3], configs),
              child: Container(
                height: CustomAdConfig.defaultBannerHeight,
                padding: const EdgeInsets.only(bottom: 30),
                child: CustomAdWidget(
                  assetUrl: configs.customAdAssetUrl,
                  targetUrl: configs.customAdDestinationUrl,
                ),
              ),
            ),
            RelatedArticles(postId: article.id, catId: article.catId),
            const SizedBox(height: 50)
          ],
        ),
      ),
    );
  }

  Widget _menuButton(BuildContext context, Article article) {
    return Container(
      width: 45,
      height: 45,
      decoration: BoxDecoration(
        color: Theme.of(context).colorScheme.surface.withValues(alpha: 0.85),
        borderRadius: BorderRadius.circular(10),
      ),
      child: PopupMenuButton<String>(
        padding: EdgeInsets.zero,
        icon: Icon(
          Icons.more_vert,
          size: 25,
          color: Theme.of(context).colorScheme.onSurface,
        ),
        onSelected: (value) {
          if (value == 'theme') {
            ref.read(themeBlocProvider).toggleTheme();
          } else if (value == 'decrease_font') {
            _decreaseFontSize();
          } else if (value == 'increase_font') {
            _increaseFontSize();
          } else if (value == 'share') {
            _handleShare();
          }
        },
        itemBuilder: (BuildContext context) => [
          PopupMenuItem<String>(
            value: 'decrease_font',
            enabled: _fontSize > _minFontSize,
            padding: const EdgeInsets.symmetric(horizontal: 0, vertical: 0),
            child: Center(
              child: Icon(
                Icons.text_decrease,
                size: 20,
                color: _fontSize <= _minFontSize
                    ? Theme.of(context)
                        .colorScheme
                        .onSurfaceVariant
                        .withValues(alpha: 0.5)
                    : Theme.of(context).colorScheme.onSurface,
              ),
            ),
          ),
          PopupMenuItem<String>(
            value: 'increase_font',
            enabled: _fontSize < _maxFontSize,
            padding: const EdgeInsets.symmetric(horizontal: 0, vertical: 0),
            child: Center(
              child: Icon(
                Icons.text_increase,
                size: 20,
                color: _fontSize >= _maxFontSize
                    ? Theme.of(context)
                        .colorScheme
                        .onSurfaceVariant
                        .withValues(alpha: 0.5)
                    : Theme.of(context).colorScheme.onSurface,
              ),
            ),
          ),
          const PopupMenuDivider(),
          PopupMenuItem<String>(
            value: 'theme',
            padding: const EdgeInsets.symmetric(horizontal: 0, vertical: 0),
            child: Center(
              child: Icon(
                ref.watch(themeBlocProvider).darkTheme == true
                    ? Icons.light_mode
                    : Icons.dark_mode,
                size: 20,
                color: Theme.of(context).colorScheme.onSurface,
              ),
            ),
          ),
          const PopupMenuDivider(),
          PopupMenuItem<String>(
            value: 'share',
            padding: const EdgeInsets.symmetric(horizontal: 0, vertical: 0),
            child: Center(
              child: Icon(
                FeatherIcons.share2,
                size: 20,
                color: Theme.of(context).colorScheme.onSurface,
              ),
            ),
          ),
        ],
      ),
    );
  }
}

class _VideoWidget extends StatelessWidget {
  const _VideoWidget({required this.article});
  final Article article;

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      bottom: false,
      top: true,
      child: Stack(
        fit: StackFit.passthrough,
        children: [
          _VideoBox(article: article),
          Align(
            alignment: Alignment.topLeft,
            child: IconButton(
              icon: Icon(
                Icons.keyboard_arrow_left,
                color: Theme.of(context).colorScheme.onPrimary,
                size: 30,
              ),
              onPressed: () => Navigator.pop(context),
            ),
          ),
        ],
      ),
    );
  }
}

class _VideoBox extends StatelessWidget {
  const _VideoBox({required this.article});
  final Article article;

  @override
  Widget build(BuildContext context) {
    if (article.videoUrl != '') {
      return VideoPlayerWidget(
        videoUrl: article.videoUrl.toString(),
        videoType: 'network',
        thumbnailUrl: article.image,
      );
    } else if (article.viemoUrl != '') {
      final String videoId = AppService.getVimeoId(article.viemoUrl.toString());
      return VideoPlayerWidget(
        videoUrl: videoId,
        videoType: 'vimeo',
        thumbnailUrl: article.image,
      );
    } else {
      return Container();
    }
  }
}
